/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.list;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.lists.ListMatchHandler;
import buildcraft.lib.BCLibProxy;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.DimensionManager;

public class ListMatchHandlerArmor
extends ListMatchHandler {
    private static EnumSet<EntityEquipmentSlot> getArmorTypes(ItemStack stack) {
        EntityPlayer player = BCLibProxy.getProxy().getClientPlayer();
        if (player == null) {
            player = BuildCraftAPI.fakePlayerProvider.getBuildCraftPlayer(DimensionManager.getWorld((int)0));
        }
        EnumSet<EntityEquipmentSlot> types = EnumSet.noneOf(EntityEquipmentSlot.class);
        for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
            if (e.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !stack.func_77973_b().isValidArmor(stack, e, (Entity)player)) continue;
            types.add(e);
        }
        return types;
    }

    @Override
    public boolean matches(ListMatchHandler.Type type, @Nonnull ItemStack stack, @Nonnull ItemStack target, boolean precise) {
        EnumSet<EntityEquipmentSlot> armorTypeIDSource;
        if (type == ListMatchHandler.Type.TYPE && (armorTypeIDSource = ListMatchHandlerArmor.getArmorTypes(stack)).size() > 0) {
            EnumSet<EntityEquipmentSlot> armorTypeIDTarget = ListMatchHandlerArmor.getArmorTypes(target);
            if (precise) {
                return armorTypeIDSource.equals(armorTypeIDTarget);
            }
            armorTypeIDSource.removeAll(EnumSet.complementOf(armorTypeIDTarget));
            return armorTypeIDSource.size() > 0;
        }
        return false;
    }

    @Override
    public boolean isValidSource(ListMatchHandler.Type type, @Nonnull ItemStack stack) {
        return ListMatchHandlerArmor.getArmorTypes(stack).size() > 0;
    }
}

