/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncLongToDouble
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncLongToDouble function;
    private final StringFunctionBi stringFunction;

    public NodeFuncLongToDouble(String name, IFuncLongToDouble function) {
        this(function, (String a) -> "[ long -> double ] " + name + "(" + a + ")");
    }

    public NodeFuncLongToDouble(IFuncLongToDouble function, StringFunctionBi stringFunction) {
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncLongToDouble setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeLong a = stack.popLong();
        return this.create(a);
    }

    public FuncLongToDouble create(IExpressionNode.INodeLong argA) {
        return new FuncLongToDouble(argA);
    }

    @FunctionalInterface
    public static interface IFuncLongToDouble {
        public double apply(long var1);
    }

    public class FuncLongToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeLong argA;

        public FuncLongToDouble(IExpressionNode.INodeLong argA) {
            this.argA = argA;
        }

        @Override
        public double evaluate() {
            return NodeFuncLongToDouble.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncLongToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncLongToDouble((IExpressionNode.INodeLong)a), a -> new FuncLongToDouble((IExpressionNode.INodeLong)a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncLongToDouble((IExpressionNode.INodeLong)a), a -> NodeConstantDouble.of(NodeFuncLongToDouble.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncLongToDouble.this.canInline) {
                if (NodeFuncLongToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncLongToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncLongToDouble.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncLongToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncLongToDouble other = (FuncLongToDouble)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

