/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.core.BCCoreConfig;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.generation.BiomeInitializer;
import buildcraft.energy.generation.BiomeOilDesert;
import buildcraft.energy.generation.BiomeOilOcean;
import buildcraft.energy.generation.OilGenerator;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildcraftenergy")
public class BCEnergyWorldGen {
    public static void init() {
        if (BCEnergyConfig.enableOilOceanBiome) {
            BiomeDictionary.addTypes((Biome)BiomeOilOcean.INSTANCE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        }
        if (BCEnergyConfig.enableOilDesertBiome) {
            BiomeDictionary.addTypes((Biome)BiomeOilDesert.INSTANCE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY});
        }
        if (BCCoreConfig.worldGen) {
            if (BCEnergyConfig.enableOilGeneration) {
                MinecraftForge.EVENT_BUS.register(OilGenerator.class);
            }
            if (BCEnergyConfig.enableOilOceanBiome || BCEnergyConfig.enableOilDesertBiome) {
                MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeInitializer());
            }
        }
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        if (BCEnergyConfig.enableOilDesertBiome) {
            event.getRegistry().register((IForgeRegistryEntry)new BiomeOilOcean());
        }
        if (BCEnergyConfig.enableOilDesertBiome) {
            event.getRegistry().register((IForgeRegistryEntry)new BiomeOilDesert());
        }
    }
}

