/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.Addon;
import buildcraft.core.marker.volume.ClientVolumeBoxes;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MessageVolumeBoxes
implements IMessage {
    private final List<PacketBufferBC> buffers;
    public static final IMessageHandler<MessageVolumeBoxes, IMessage> HANDLER = (message, ctx) -> {
        Map<PacketBufferBC, VolumeBox> volumeBoxes = message.buffers.stream().map(buffer -> {
            VolumeBox volumeBox;
            try {
                volumeBox = new VolumeBox(BCLibProxy.getProxy().getClientWorld(), (PacketBufferBC)((Object)((Object)buffer)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            PacketBufferBC buf = new PacketBufferBC(Unpooled.buffer());
            volumeBox.toBytes(buf);
            return Pair.of((Object)((Object)buf), (Object)volumeBox);
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        ClientVolumeBoxes.INSTANCE.volumeBoxes.removeIf(volumeBox -> !volumeBoxes.values().contains(volumeBox));
        for (Map.Entry<PacketBufferBC, VolumeBox> entry : volumeBoxes.entrySet()) {
            boolean wasContained = false;
            for (VolumeBox clientVolumeBox : ClientVolumeBoxes.INSTANCE.volumeBoxes) {
                if (!clientVolumeBox.equals(entry.getValue())) continue;
                try {
                    clientVolumeBox.fromBytes(entry.getKey());
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
                wasContained = true;
                break;
            }
            if (wasContained) continue;
            ClientVolumeBoxes.INSTANCE.volumeBoxes.add(entry.getValue());
            for (Addon addon : entry.getValue().addons.values()) {
                if (addon == null) continue;
                addon.onAdded();
            }
        }
        return null;
    };

    public MessageVolumeBoxes() {
        this.buffers = new ArrayList<PacketBufferBC>();
    }

    public MessageVolumeBoxes(List<VolumeBox> volumeBoxes) {
        this.buffers = volumeBoxes.stream().map(volumeBox -> {
            PacketBufferBC buffer = new PacketBufferBC(Unpooled.buffer());
            volumeBox.toBytes(buffer);
            return buffer;
        }).collect(Collectors.toList());
    }

    public void toBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        buf.writeInt(this.buffers.size());
        for (PacketBufferBC localBuffer : this.buffers) {
            buf.func_150787_b(localBuffer.readableBytes());
            buf.writeBytes((ByteBuf)localBuffer, 0, localBuffer.readableBytes());
        }
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        this.buffers.clear();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            int bytes = buf.func_150792_a();
            PacketBufferBC packet = new PacketBufferBC(buf.readBytes(bytes));
            this.buffers.add(packet);
        }
    }
}

