/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.crafttweaker;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.mj.MjAPI;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.CombustionEngine")
@ModOnly(value="buildcraftenergy")
public class CombustionEngine {
    private static final double MAX_POWER = 100000.0;

    @ZenMethod
    public static void addCleanFuel(ILiquidStack liquid, double powerPerTick, int timePerBucket) {
        FluidStack fluid = CraftTweakerMC.getLiquidStack((ILiquidStack)liquid);
        if (fluid == null) {
            throw new IllegalArgumentException("Fluid was null!");
        }
        if (BuildcraftFuelRegistry.fuel.getFuel(fluid) != null) {
            throw new IllegalArgumentException("The fluid " + fluid + " is already registered as a fuel!");
        }
        if (BuildcraftFuelRegistry.coolant.getCoolant(fluid) != null) {
            throw new IllegalArgumentException("The fluid " + fluid + " is already registered as a coolant - so it won't work very well if you add it as a fuel too!");
        }
        if (powerPerTick <= 0.0) {
            throw new IllegalArgumentException("Power was less than or equal to 0!");
        }
        if (powerPerTick > 100000.0) {
            throw new IllegalArgumentException("Maximum power is 100000.0, as any values above this would instantly bring the engine to overheat.");
        }
        long mj = (long)((double)MjAPI.MJ * powerPerTick);
        CraftTweakerAPI.apply((IAction)new AddCleanFuel(fluid, mj, timePerBucket));
    }

    @ZenMethod
    public static void addDirtyFuel(ILiquidStack lFuel, double powerPerTick, int timePerBucket, ILiquidStack lResidue) {
        FluidStack fuel = CraftTweakerMC.getLiquidStack((ILiquidStack)lFuel);
        FluidStack residue = CraftTweakerMC.getLiquidStack((ILiquidStack)lResidue);
        if (fuel.getFluid() == null) {
            throw new IllegalArgumentException("Fuel fluid was null!");
        }
        if (residue.getFluid() == null) {
            throw new IllegalArgumentException("Residue fluid was null!");
        }
        if (BuildcraftFuelRegistry.fuel.getFuel(fuel) != null) {
            throw new IllegalArgumentException("The fluid " + fuel + " is already registered as a fuel!");
        }
        if (BuildcraftFuelRegistry.coolant.getCoolant(fuel) != null) {
            throw new IllegalArgumentException("The fluid " + fuel + " is already registered as a coolant - so it won't work very well if you add it as a fuel too!");
        }
        if (powerPerTick <= 0.0) {
            throw new IllegalArgumentException("Power was less than or equal to 0!");
        }
        if (powerPerTick > 100000.0) {
            throw new IllegalArgumentException("Maximum power is 100000.0, as any values above this would instantly bring the engine to overheat.");
        }
        long mj = (long)((double)MjAPI.MJ * powerPerTick);
        CraftTweakerAPI.apply((IAction)new AddDirtyFuel(fuel, mj, timePerBucket, residue));
    }

    static final class AddDirtyFuel
    implements IAction {
        private final FluidStack fuel;
        private final FluidStack residue;
        private final long powerPerTick;
        private final int totalBurningTime;

        public AddDirtyFuel(FluidStack fuel, long powerPerCycle, int totalBurningTime, FluidStack residue) {
            this.fuel = fuel;
            this.powerPerTick = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
            this.residue = residue;
        }

        public void apply() {
            BuildcraftFuelRegistry.fuel.addDirtyFuel(this.fuel, this.powerPerTick, this.totalBurningTime, this.residue);
        }

        public String describe() {
            return "Adding combustion engine fuel " + this.fuel;
        }
    }

    static final class AddCleanFuel
    implements IAction {
        private final FluidStack fluid;
        private final long powerPerTick;
        private final int totalBurningTime;

        public AddCleanFuel(FluidStack fluid, long powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerTick = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        public void apply() {
            BuildcraftFuelRegistry.fuel.addFuel(this.fluid, this.powerPerTick, this.totalBurningTime);
        }

        public String describe() {
            return "Adding combustion engine fuel " + this.fluid;
        }
    }
}

