/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class ModDocContainer {
    public static final int VERSION_STAT_OK = 0;
    public static final int VERSION_STAT_OLD = 1;
    public static final int VERSION_STAT_ERROR = 2;
    public final String modid;
    public final Map<String, Element> langToElement = new HashMap<String, Element>();
    public final Map<String, Integer> langToVersion = new HashMap<String, Integer>();
    public final Map<String, Integer> langToVerState = new HashMap<String, Integer>();
    public String langStatus = null;
    public String langOverride = null;

    public ModDocContainer(String modid, Element initialElement, String lang) {
        this.modid = modid;
        this.addModDocForLang(lang, initialElement);
    }

    public Element getElement(String lang) {
        if (this.langOverride != null) {
            if (this.langToElement.containsKey(this.langOverride)) {
                return this.langToElement.get(this.langOverride);
            }
            this.langStatus = "guiwiki.langStatus.OverrideFailed";
        }
        if (this.langToElement.containsKey(lang)) {
            return this.langToElement.get(lang);
        }
        if (this.langToElement.containsKey("en_US")) {
            this.langStatus = "guiwiki.langStatus.NADefaultLoaded";
            return this.langToElement.get("en_US");
        }
        ArrayList<String> entries = new ArrayList<String>(this.langToElement.keySet());
        if (entries.size() > 0) {
            this.langStatus = "guiwiki.langStatus.ErrorFirstLoaded";
            return this.langToElement.get(entries.get(0));
        }
        this.langStatus = "guiwiki.langStatus.Error";
        return null;
    }

    public void addModDocForLang(String lang, Element modElement) {
        this.langToElement.put(lang, modElement);
        int version = this.getVersion(modElement);
        this.langToVersion.put(lang, version);
        if (version == -1) {
            this.langToVerState.put(lang, 2);
        } else {
            this.langToVerState.put(lang, 0);
        }
    }

    public int getVersion(Element modElement) {
        try {
            return Integer.parseInt(modElement.getAttribute("docRevision"));
        }
        catch (Exception e) {
            return -1;
        }
    }
}

