/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.advanced;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduit;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.GasConduitObject;
import gg.galaxygaming.gasconduits.common.conduit.GasOutput;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.advanced.AdvancedGasConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduitNetwork;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedGasConduit
extends AbstractGasTankConduit {
    public static final int CONDUIT_VOLUME = 1000;
    public static final IConduitTexture ICON_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit", (boolean)false), ConduitTexture.arm((int)1));
    public static final IConduitTexture ICON_KEY_LOCKED = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit", (boolean)false), ConduitTexture.arm((int)2));
    public static final IConduitTexture ICON_CORE_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_core", (boolean)false), ConduitTexture.core((int)1));
    public static final TextureRegistry.TextureSupplier ICON_EMPTY_EDGE = TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_advanced_edge", (boolean)false);
    private AdvancedGasConduitNetwork network;
    private long ticksSinceFailedExtract = 0L;

    public AdvancedGasConduit() {
        this.updateTank();
    }

    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K) {
            this.doExtract();
            if (this.stateDirty) {
                this.getBundle().dirty();
                this.stateDirty = false;
            }
        }
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        if (this.network == null) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 25L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        int tier2ExtractRate = (Integer)GasConduitConfig.tier2_extractRate.get();
        for (EnumFacing dir : this.externalConnections) {
            if (!this.autoExtractForDir(dir) || !this.network.extractFrom(this, dir, tier2ExtractRate)) continue;
            this.ticksSinceFailedExtract = 0L;
        }
    }

    @Override
    protected void updateTank() {
        this.tank.setMaxGas(1000);
        if (this.network != null) {
            this.network.updateConduitVolumes();
        }
    }

    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(GasConduitObject.itemGasConduit.getItemNN(), 1, 1);
    }

    @Nullable
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (!(network instanceof AdvancedGasConduitNetwork)) {
            return false;
        }
        AdvancedGasConduitNetwork n = (AdvancedGasConduitNetwork)network;
        if (this.tank.getGas() == null) {
            this.tank.setGas(n.getGasType() == null ? null : n.getGasType().copy());
        } else if (n.getGasType() == null) {
            n.setGasType(this.tank.getGas());
        } else if (!this.tank.getGas().isGasEqual(n.getGasType())) {
            return false;
        }
        this.network = n;
        return super.setNetwork(network);
    }

    public void clearNetwork() {
        this.network = null;
    }

    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        if (!super.canConnectToConduit(direction, con) || !(con instanceof AdvancedGasConduit)) {
            return false;
        }
        return GasConduitNetwork.areGasesCompatible(this.getGasType(), ((AdvancedGasConduit)con).getGasType());
    }

    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.refreshInputs(dir);
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        super.setExtractionRedstoneMode(mode, dir);
        this.refreshInputs(dir);
    }

    private void refreshInputs(@Nonnull EnumFacing dir) {
        if (this.network != null) {
            GasOutput lo = new GasOutput(this.getBundle().getLocation().func_177972_a(dir), dir.func_176734_d());
            this.network.removeInput(lo);
            if (this.canInputToDir(dir) && this.containsExternalConnection(dir)) {
                this.network.addInput(lo);
            }
        }
    }

    public void externalConnectionAdded(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.refreshInputs(fromDirection);
    }

    public void externalConnectionRemoved(@Nonnull EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.refreshInputs(fromDirection);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return ICON_CORE_KEY;
        }
        if ("ColorController".equals(component.data)) {
            return new ConduitTextureWrapper(IconUtil.instance.whiteTexture);
        }
        return this.gasTypeLocked ? ICON_KEY_LOCKED : ICON_KEY;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getNotSetEdgeTexture() {
        return (TextureAtlasSprite)ICON_EMPTY_EDGE.get(TextureAtlasSprite.class);
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (this.network == null) {
            gasTankInfoArray = new GasTankInfo[]{};
        } else {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[1];
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[0] = this.tank;
        }
        return gasTankInfoArray;
    }

    public int receiveGas(EnumFacing side, GasStack resource, boolean doFill) {
        return this.network == null || !this.canReceiveGas(side, resource.getGas()) ? 0 : this.network.receiveGas(resource, doFill);
    }

    @Nullable
    public GasStack drawGas(EnumFacing side, int maxDrain, boolean doDrain) {
        return this.network == null || !this.canDrawGas(side, this.tank.getGasType()) ? null : this.network.drawGas(maxDrain, doDrain);
    }

    @Override
    protected boolean canJoinNeighbour(IGasConduit n) {
        return n instanceof AdvancedGasConduit;
    }

    @Override
    public AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> getTankNetwork() {
        return this.network;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        GasStack gasType = this.getGasType();
        if (gasType != null && gasType.getGas() != null) {
            hashCodes.add((Object)gasType.getGas());
        }
        hashCodes.addEnum((Map)this.extractionColors);
        hashCodes.addEnum((Map)this.extractionModes);
    }

    @Nonnull
    public AdvancedGasConduitNetwork createNetworkForType() {
        return new AdvancedGasConduitNetwork();
    }

    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection baseCollidables = super.createCollidables(key);
        EnumFacing keyDir = key.dir;
        if (keyDir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.getInstance().createBoundsForConnectionController(keyDir, key.offset);
        CollidableComponent cc = new CollidableComponent(IGasConduit.class, bb, keyDir, (Object)"ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>(baseCollidables);
        result.add(cc);
        return result;
    }
}

