/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.worldportals.client.core;

import java.util.HashSet;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.module.worldportals.client.render.WorldPortalRenderer;
import me.ichun.mods.ichunutil.common.module.worldportals.client.render.world.RenderGlobalProxy;
import me.ichun.mods.ichunutil.common.module.worldportals.common.WorldPortals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlerWorldPortalClient {
    public float prevCameraRoll;
    public float cameraRoll;
    public WorldClient instance;
    public RenderGlobalProxy renderGlobalProxy;
    public HashSet<AxisAlignedBB> aabbToRender = new HashSet();

    @SubscribeEvent
    public void onCameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
        if (this.cameraRoll != 0.0f && WorldPortalRenderer.renderLevel <= 0) {
            event.setRoll(EntityHelper.interpolateValues(this.prevCameraRoll, this.cameraRoll, (float)event.getRenderPartialTicks()));
        }
    }

    @SubscribeEvent
    public void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        if (WorldPortals.eventHandler.isInPortal((Entity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPushPlayerSPOutOfBlock(PlayerSPPushOutOfBlocksEvent event) {
        if (WorldPortals.eventHandler.isInPortal((Entity)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            if (this.instance != mc.field_71441_e) {
                this.instance = mc.field_71441_e;
                if (this.renderGlobalProxy == null) {
                    this.renderGlobalProxy = new RenderGlobalProxy(mc);
                    this.renderGlobalProxy.func_174971_n();
                }
                this.renderGlobalProxy.func_72732_a(this.instance);
            }
            WorldPortalRenderer.renderLevel = 0;
            WorldPortalRenderer.renderCount = 0;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.prevCameraRoll = this.cameraRoll;
            this.cameraRoll *= 0.85f;
            if (Math.abs(this.cameraRoll) < 0.05f) {
                this.cameraRoll = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(this::disconnectFromServer);
    }

    public void disconnectFromServer() {
        WorldPortals.eventHandler.monitoredEntities.get(Side.CLIENT).clear();
        WorldPortalRenderer.renderLevel = 0;
        WorldPortalRenderer.rollFactor.clear();
    }
}

