/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class IconHelper {
    public static final String EXPANSION_POINT = ":";
    public static final String EXPANSION_BLOCK = ":blocks/";
    public static final String EXPANSION_ITEM = ":items/";
    private static final Map<String, Deque<String>> FIND_CACHE = new HashMap<String, Deque<String>>();
    private static final AtomicInteger FAIL_COUNTER = new AtomicInteger();

    private IconHelper() {
    }

    public static TextureAtlasSprite getDefaultIcon() {
        return DefaultIcon.instance;
    }

    public static TextureAtlasSprite getIcon(String resourceLocation) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(resourceLocation);
        if (!sprite.func_94215_i().equals("missingno")) {
            return sprite;
        }
        int fail = FAIL_COUNTER.addAndGet(1);
        return IconHelper.getDefaultIcon();
    }

    private static TextureAtlasSprite getIcon(String path, String expansion) {
        return IconHelper.getIcon(path, expansion, "");
    }

    private static TextureAtlasSprite getIcon(String path, String expansion, String postfix) {
        return IconHelper.getIcon(path.replaceFirst(EXPANSION_POINT, expansion).concat(postfix));
    }

    public static TextureAtlasSprite getIcon(Block block) {
        return block == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(block.getRegistryName().toString(), EXPANSION_BLOCK);
    }

    public static TextureAtlasSprite getIcon(Item item) {
        return item == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(item.getRegistryName().toString(), EXPANSION_ITEM);
    }

    public static TextureAtlasSprite getIcon(FluidStack stack) {
        return stack == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(stack.getFluid().getStill(stack).toString());
    }

    public static TextureAtlasSprite getIcon(Fluid fluid) {
        return fluid == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(fluid.getStill().toString());
    }

    public static TextureAtlasSprite getParticleIcon(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public static TextureAtlasSprite getParticleIcon(Item item, int meta) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(item, meta);
    }

    public static TextureAtlasSprite registerIcon(String texturePath) {
        Preconditions.checkNotNull((Object)texturePath, (Object)"IconHelper cannot register an icon with a null texture path!");
        return IconHelper.registerIcon(new ResourceLocation(texturePath));
    }

    @Nonnull
    public static TextureAtlasSprite registerIcon(@Nonnull ResourceLocation texturePath) {
        Preconditions.checkNotNull((Object)texturePath, (Object)"IconHelper cannot register an icon with a null texture path!");
        TextureAtlasSprite ret = null;
        try {
            ret = Minecraft.func_71410_x().func_147117_R().func_174942_a(texturePath);
        }
        catch (Exception e) {
            AgriCore.getLogger("agricraft").debug(e.getLocalizedMessage(), new Object[0]);
        }
        if (ret != null) {
            return ret;
        }
        return IconHelper.getDefaultIcon();
    }

    public static Deque<String> findMatches(String name) {
        if (FIND_CACHE.containsKey(name = name.toLowerCase())) {
            return FIND_CACHE.get(name);
        }
        ArrayDeque<String> matches = new ArrayDeque<String>();
        try {
            Field f = TextureMap.class.getDeclaredField("mapRegisteredSprites");
            f.setAccessible(true);
            Map textureMap = (Map)f.get(Minecraft.func_71410_x().func_147117_R());
            for (String e : textureMap.keySet()) {
                if (!e.contains(name)) continue;
                matches.add(e);
            }
            if (!FIND_CACHE.isEmpty()) {
                FIND_CACHE.put(name, matches);
            } else {
                matches.add("missingno");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            AgriCore.getLogger("agricraft").debug("Something strange is going on with the Minecraft TextureMap!", new Object[0]);
        }
        catch (SecurityException e) {
            AgriCore.getLogger("agricraft").debug("Locked out of TextureMap...", new Object[0]);
        }
        return matches;
    }

    private static class DefaultIcon
    extends TextureAtlasSprite {
        public static final TextureAtlasSprite instance = new DefaultIcon("missingno");

        private DefaultIcon(String location) {
            super(location);
            this.field_130223_c = 16;
            this.field_130224_d = 16;
            this.field_110976_a = new ArrayList(1);
            this.field_110976_a.add(new int[][]{TextureUtil.field_110999_b});
        }
    }
}

