/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomWoodType {
    @Nonnull
    private final Block block;
    private final int meta;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite texture;

    protected CustomWoodType(@Nonnull Block block, int meta) {
        this.block = (Block)Preconditions.checkNotNull((Object)block);
        this.meta = meta;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getState() {
        return this.getBlock().func_176203_a(this.getMeta());
    }

    public ItemStack getStack() {
        return new ItemStack(this.getBlock(), 1, this.getMeta());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("agri_material", this.getBlock().getRegistryName().toString());
        tag.func_74768_a("agri_material_meta", this.getMeta());
        return tag;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CustomWoodType) {
            CustomWoodType other = (CustomWoodType)obj;
            return other.getBlock() == this.getBlock() && other.getMeta() == this.getMeta();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getBlock(), this.getMeta()});
    }

    public String toString() {
        return this.block.getRegistryName() + ":" + this.meta;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getIcon() {
        if (this.texture == null) {
            try {
                IBlockState state = this.block.func_176203_a(this.meta);
                this.texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            }
            catch (Exception e) {
                AgriCore.getLogger("agricraft").debug("Unable to load texture for custom wood block {0}!", this.block.func_149732_F());
                AgriCore.getLogger("agricraft").trace(e);
                this.texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
        }
        return this.texture;
    }
}

