/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.mutation;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAgriMutationEngine {
    public boolean registerStrategy(@Nonnull IAgriCrossStrategy var1);

    @Nonnull
    public List<IAgriCrossStrategy> getStrategies();

    public boolean hasStrategy(@Nullable IAgriCrossStrategy var1);

    @Nonnull
    public Optional<IAgriCrossStrategy> rollStrategy(@Nonnull Random var1);

    default public boolean attemptCross(@Nonnull IAgriCrop crop, @Nonnull Random rand) {
        Preconditions.checkNotNull((Object)crop, (Object)"You cannot mutate or spread a null crop! Why would you even try this\u203d");
        Preconditions.checkNotNull((Object)rand, (Object)"The mutation engine requires a non-null random instance to work!");
        return this.rollStrategy(rand).flatMap(s -> s.executeStrategy(crop, rand)).filter(crop::isFertile).map(seed -> {
            crop.setCrossCrop(false);
            crop.setSeed((AgriSeed)seed);
            return true;
        }).orElse(false);
    }
}

