/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.lang;

import com.agricraft.agricore.lang.AgriTranslationAdapter;
import java.util.ArrayList;
import java.util.List;

public class AgriTranslator {
    private final AgriTranslationAdapter adapter;

    public AgriTranslator(AgriTranslationAdapter adapter) {
        this.adapter = adapter;
    }

    public String translateKeyOrDefault(String key, String def) {
        String trans = this.adapter.translateKey(key);
        return trans.equals(key) ? def : trans;
    }

    public String translate(Object key) {
        return this.adapter.translateKey(String.valueOf(key));
    }

    public String translateIf(Object message, boolean condition) {
        return condition ? this.translate(message) : String.valueOf(message);
    }

    public List<String> translate(List<?> message) {
        if (message != null) {
            ArrayList<String> translation = new ArrayList<String>(message.size());
            message.forEach(e -> translation.add(this.translate(e)));
            return translation;
        }
        return null;
    }

    public List<String> translateIf(List<String> message, boolean condition) {
        return condition ? this.translate(message) : message;
    }

    public String getLocale() {
        return this.adapter.getLocale();
    }
}

