/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element.tab;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class TabRedstoneControl
extends TabBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 13640458;
    private IRedstoneControl myContainer;

    public TabRedstoneControl(GuiContainerCore gui, IRedstoneControl container) {
        this(gui, defaultSide, container);
    }

    public TabRedstoneControl(GuiContainerCore gui, int side, IRedstoneControl container) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.myContainer = container;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.redstoneControl"));
            if (this.myContainer.getControl().isDisabled()) {
                list.add("\u00a7e" + StringHelper.localize("info.cofh.disabled"));
                return;
            }
            if (this.myContainer.getControl().isLow()) {
                list.add("\u00a7e" + StringHelper.localize("info.cofh.enabled") + ", " + StringHelper.localize("info.cofh.low"));
                return;
            }
            list.add("\u00a7e" + StringHelper.localize("info.cofh.enabled") + ", " + StringHelper.localize("info.cofh.high"));
            return;
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.ignored"));
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.low"));
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            list.add(StringHelper.localize("info.cofh.high"));
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            mouseX += this.currentWidth;
        }
        if ((mouseX -= this.currentShiftX) < 24 || mouseX >= 88 || (mouseY -= this.currentShiftY) < 16 || mouseY >= 40) {
            return false;
        }
        if (28 <= mouseX && mouseX < 44 && 20 <= mouseY && mouseY < 36) {
            if (!this.myContainer.getControl().isDisabled()) {
                this.myContainer.setControl(IRedstoneControl.ControlMode.DISABLED);
                GuiContainerCore.playClickSound(0.4f);
            }
        } else if (48 <= mouseX && mouseX < 64 && 20 <= mouseY && mouseY < 36) {
            if (!this.myContainer.getControl().isLow()) {
                this.myContainer.setControl(IRedstoneControl.ControlMode.LOW);
                GuiContainerCore.playClickSound(0.6f);
            }
        } else if (68 <= mouseX && mouseX < 84 && 20 <= mouseY && mouseY < 36 && !this.myContainer.getControl().isHigh()) {
            this.myContainer.setControl(IRedstoneControl.ControlMode.HIGH);
            GuiContainerCore.playClickSound(0.8f);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(24, 16, 16, 20, 64, 24);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_REDSTONE_ON);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.redstoneControl"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.controlStatus") + ":", (float)(this.sideOffset() + 6), 42.0f, this.subheaderColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.signalRequired") + ":", (float)(this.sideOffset() + 6), 66.0f, this.subheaderColor);
        if (this.myContainer.getControl().isDisabled()) {
            this.gui.drawButton(CoreTextures.ICON_REDSTONE_OFF, 28, 20, 1);
            this.gui.drawButton(CoreTextures.ICON_RS_TORCH_OFF, 48, 20, 0);
            this.gui.drawButton(CoreTextures.ICON_RS_TORCH_ON, 68, 20, 0);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.disabled"), this.sideOffset() + 14, 54, this.textColor);
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.ignored"), this.sideOffset() + 14, 78, this.textColor);
        } else {
            this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.enabled"), this.sideOffset() + 14, 54, this.textColor);
            this.gui.drawButton(CoreTextures.ICON_REDSTONE_OFF, 28, 20, 0);
            if (this.myContainer.getControl().isLow()) {
                this.gui.drawButton(CoreTextures.ICON_RS_TORCH_OFF, 48, 20, 1);
                this.gui.drawButton(CoreTextures.ICON_RS_TORCH_ON, 68, 20, 0);
                this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.low"), this.sideOffset() + 14, 78, this.textColor);
            } else {
                this.gui.drawButton(CoreTextures.ICON_RS_TORCH_OFF, 48, 20, 0);
                this.gui.drawButton(CoreTextures.ICON_RS_TORCH_ON, 68, 20, 1);
                this.getFontRenderer().func_78276_b(StringHelper.localize("info.cofh.high"), this.sideOffset() + 14, 78, this.textColor);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

