/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.gui.config.GuiIncompatibleConfig;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiTest;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.command.BCUtilCommands;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.registry.ModConfigParser;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class BCClientCommands
extends CommandBase {
    private static Map<String, PairKV<Integer, Integer>> RESOLUTIONS = new HashMap<String, PairKV<Integer, Integer>>();

    public String func_71517_b() {
        return "bcore_client";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bcore_client help";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        sender = Minecraft.func_71410_x().field_71439_g;
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        try {
            String function = args[0];
            if (function.equals("config_sync_gui")) {
                this.configSync(server, sender, args);
            } else if (function.equals("nbt")) {
                this.functionNBT(server, sender, args);
            } else if (function.equals("testui")) {
                DelayedTask.run(10, () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new ModularGuiTest()));
            } else if (function.equals("profiler")) {
                BCProfiler.enableProfiler = !BCProfiler.enableProfiler;
            } else if (function.equals("dump_event_listeners")) {
                BCUtilCommands.dumpEventListeners(sender);
            } else if (function.equals("set_ui_scale")) {
                this.setUiScale(server, sender, args);
            } else if (function.equals("set_ui_size")) {
                this.setUISize(server, sender, args);
            } else if (function.equals("clear_fx")) {
                BCEffectHandler.effectRenderer.clear();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 2 && args[0].equals("set_ui_size")) {
            return BCClientCommands.func_175762_a((String[])args, RESOLUTIONS.keySet());
        }
        return BCClientCommands.func_71530_a((String[])args, (String[])new String[]{"nbt", "profiler", "dump_event_listeners", "set_ui_scale", "clear_fx", "set_ui_size"});
    }

    private void help(ICommandSender sender) {
        ChatHelper.message(sender, "NO!", TextFormatting.RED);
    }

    private void configSync(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!ModConfigParser.propsRequireRestart.isEmpty()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiIncompatibleConfig(ModConfigParser.propsRequireRestart));
        }
    }

    private void functionNBT(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = HandHelper.getMainFirst(player);
        if (stack.func_190926_b()) {
            throw new CommandException("You are not holding an item!", new Object[0]);
        }
        if (!stack.func_77942_o()) {
            throw new CommandException("That stack has no NBT tag!", new Object[0]);
        }
        NBTTagCompound compound = stack.func_77978_p();
        LogHelperBC.logNBT(compound);
        String s = compound + "";
        if (args.length == 2) {
            s = new StackReference(stack).toString();
        }
        LogHelperBC.info(s);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (NBTBase)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, st -> ChatHelper.message(sender, st, TextFormatting.GOLD));
        if (!StringUtils.isEmpty((CharSequence)(compound + "")) && !BrandonsCore.proxy.isDedicatedServer()) {
            try {
                StringSelection stringselection = new StringSelection(s);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
                ChatHelper.message(sender, "NBT Copied to clipboard!", TextFormatting.GREEN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setUiScale(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /bcore_client set_ui_scale <0 to 8>"));
            return;
        }
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = BCClientCommands.func_175764_a((String)args[1], (int)0, (int)8);
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        sender.func_145747_a((ITextComponent)new TextComponentString("Gui Scale Updated!"));
    }

    private void setUISize(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int height;
        int width;
        if (!(args.length <= 3 && args.length >= 2 || RESOLUTIONS.containsKey(args[1]))) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /set_ui_size (<width> <height> or <res name>)"));
            return;
        }
        if (args.length == 2) {
            width = RESOLUTIONS.get(args[1]).getKey();
            height = RESOLUTIONS.get(args[1]).getValue();
        } else {
            width = BCClientCommands.func_175764_a((String)args[1], (int)64, (int)7680);
            height = BCClientCommands.func_175764_a((String)args[2], (int)64, (int)4320);
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_71370_a(width, height);
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(mc.field_71443_c, mc.field_71440_d));
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    static {
        RESOLUTIONS.put("240p", new PairKV<Integer, Integer>(352, 240));
        RESOLUTIONS.put("360p", new PairKV<Integer, Integer>(480, 360));
        RESOLUTIONS.put("480p", new PairKV<Integer, Integer>(858, 480));
        RESOLUTIONS.put("576p", new PairKV<Integer, Integer>(1024, 576));
        RESOLUTIONS.put("648p", new PairKV<Integer, Integer>(1152, 648));
        RESOLUTIONS.put("720p", new PairKV<Integer, Integer>(1280, 720));
        RESOLUTIONS.put("768p", new PairKV<Integer, Integer>(1366, 768));
        RESOLUTIONS.put("900p", new PairKV<Integer, Integer>(1600, 900));
        RESOLUTIONS.put("1080p", new PairKV<Integer, Integer>(1920, 1080));
        RESOLUTIONS.put("1440p", new PairKV<Integer, Integer>(2560, 1440));
        RESOLUTIONS.put("4k", new PairKV<Integer, Integer>(3840, 2160));
        RESOLUTIONS.put("8k", new PairKV<Integer, Integer>(7680, 4320));
    }
}

