/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementFactory;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.CellData;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.TableDefinition;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.VAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.MarkdownVisitor;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class TableElement
extends MDElementBase<TableElement> {
    public int rows = 0;
    public int columns = 0;
    public boolean renderCells = true;
    private MDElementContainer container;
    public TableDefinition definition;
    private List<TableCellContainer> tableCells = new ArrayList<TableCellContainer>();
    private int[] rowLines = new int[0];
    private int[] columnLines = new int[0];

    public TableElement(MDElementContainer container, TableDefinition definition) {
        this.topPad = 1;
        this.rightPad = 1;
        this.leftPad = 1;
        this.bottomPad = 1;
        this.container = container;
        this.definition = definition;
        this.width = 100;
        this.screenRelativeSize = true;
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        int width = this.screenRelativeSize ? (int)(MathHelper.clip((double)((double)this.width / 100.0), (double)0.0, (double)1.0) * (double)layout.getWidth()) : MathHelper.clip((int)this.width, (int)0, (int)layout.getWidth());
        this.rowLines = new int[this.rows + 1];
        this.columnLines = new int[this.columns + 1];
        int cbw = this.renderCells ? 1 : 0;
        double dynamicWidth = width -= cbw * (this.columns + 1);
        double dynamicRange = 0.0;
        boolean dynamic = false;
        for (TableDefinition.ColumnDef data : this.definition.columns) {
            if (data.fixedWidth) {
                dynamicWidth -= (double)data.width;
                continue;
            }
            dynamicRange += (double)data.width;
            dynamic = true;
        }
        int[] xOffsets = new int[this.definition.columns.size()];
        int currentXOffset = 0;
        for (int i = 0; i < this.columns; ++i) {
            if (i >= this.definition.columns.size()) continue;
            this.columnLines[i] = currentXOffset;
            TableDefinition.ColumnDef data = this.definition.columns.get(i);
            xOffsets[i] = currentXOffset += cbw;
            currentXOffset += data.fixedWidth ? data.width : (int)((double)data.width / dynamicRange * dynamicWidth);
        }
        this.columnLines[this.columnLines.length - 1] = currentXOffset;
        if (!dynamic) {
            width = (int)((double)width - dynamicWidth);
        }
        int rowYPos = this.yPos() + cbw;
        int totalXSize = 0;
        for (int row = 0; row < this.rows; ++row) {
            this.rowLines[row] = rowYPos - cbw - this.yPos();
            int rowHeight = this.height;
            for (TableCellContainer cell : this.tableCells) {
                if (((TableCellContainer)cell).data.row != row || ((TableCellContainer)cell).data.column < 0 || ((TableCellContainer)cell).data.column >= xOffsets.length) continue;
                TableDefinition.ColumnDef column = cell.columnDef;
                int cellWidth = column.fixedWidth ? column.width : (int)((double)column.width / dynamicRange * dynamicWidth);
                cell.container.setXSize(cellWidth);
                cell.container.setPos(this.xPos() + xOffsets[((TableCellContainer)cell).data.column], rowYPos);
                cell.container.layoutMarkdownElements();
                totalXSize = Math.max(totalXSize, cell.container.maxXPos() - this.xPos());
                rowHeight = Math.max(rowHeight, cell.container.ySize());
                if (this.childElements.contains(cell.container)) continue;
                this.addChild(cell.container);
            }
            for (TableCellContainer cell : this.tableCells) {
                if (((TableCellContainer)cell).data.row != row || ((TableCellContainer)cell).data.column < 0 || ((TableCellContainer)cell).data.column >= xOffsets.length) continue;
                if (((TableCellContainer)cell).data.vAlign != VAlign.TOP) {
                    cell.container.translate(0, (rowHeight - cell.container.ySize()) / (((TableCellContainer)cell).data.vAlign == VAlign.MIDDLE ? 2 : 1));
                }
                cell.background.setYSize(rowHeight);
                cell.background.setYPos(rowYPos);
            }
            rowYPos += rowHeight + cbw;
        }
        this.rowLines[row] = rowYPos - cbw - this.yPos();
        width = totalXSize + cbw;
        this.setSize(width, rowYPos - this.yPos());
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.renderCells) {
            for (int row : this.rowLines) {
                this.drawColouredRect(this.xPos(), this.yPos() + row, this.xSize(), 1.0, 0xFF000000 | this.colourBorder);
            }
            for (int column : this.columnLines) {
                this.drawColouredRect(this.xPos() + column, this.yPos(), 1.0, this.ySize(), 0xFF000000 | this.colourBorder);
            }
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public TableCellContainer getCreateCell(CellData data) {
        TableCellContainer cell = DataUtils.firstMatch(this.tableCells, c -> ((TableCellContainer)c).data.equals(data));
        if (cell == null) {
            if (data.column >= 0 && data.column < this.definition.columns.size()) {
                cell = new TableCellContainer(data, this.container, this.definition.columns.get(data.column), this.definition);
            } else {
                cell = new TableCellContainer(data, this.container, new TableDefinition.ColumnDef(10, true, HAlign.LEFT), this.definition);
                this.error("Invalid table layout! Attempt to assign cell in non-existent column");
            }
            this.tableCells.add(cell);
            this.columns = Math.max(this.columns, data.column + 1);
            this.rows = Math.max(this.rows, data.row + 1);
        }
        return cell;
    }

    public static class TableCellContainer {
        public MDElementContainer container = null;
        private CellData data;
        private MDElementContainer parentContainer;
        private TableDefinition.ColumnDef columnDef;
        public TableDefinition tableDefinition;
        public GuiBorderedRect background;

        public TableCellContainer(CellData data, MDElementContainer parentContainer, TableDefinition.ColumnDef columnDef, TableDefinition tableDefinition) {
            this.data = data;
            this.parentContainer = parentContainer;
            this.columnDef = columnDef;
            this.tableDefinition = tableDefinition;
        }

        public MarkdownVisitor createContainer() {
            this.container = new MDElementContainer(this.parentContainer);
            this.container.inherit(this.parentContainer);
            this.container.defaultAlignment = this.data.hAlign;
            this.background = new GuiBorderedRect();
            this.background.setFillColour(0);
            this.background.setPos(this.container);
            this.background.setXSizeMod((guiBorderedRect, integer) -> this.container.xSize());
            this.container.addChild(this.background);
            MDElementFactory factory = new MDElementFactory(this.container);
            if (this.parentContainer.lastFactory != null) {
                factory.inherit(this.parentContainer.lastFactory);
            }
            return factory;
        }
    }
}

