/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.BlockExtraDrawers;
import com.jaquadro.minecraft.storagedrawersextra.block.BlockTrimExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.client.model.ExtraDrawerModel;
import com.jaquadro.minecraft.storagedrawersextra.client.model.ExtraTrimModel;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.item.ItemExtraDrawers;
import com.jaquadro.minecraft.storagedrawersextra.item.ItemTrimExtra;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockExtraDrawers extraDrawers;
    public static BlockTrimExtra[] extraTrim;

    @Mod.EventBusSubscriber(modid="storagedrawersextra")
    public static class Registration {
        private static final ResourceLocation EMPTY_GROUP = new ResourceLocation("", "");

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            extraDrawers = new BlockExtraDrawers("extra_drawers", "extraDrawers");
            registry.register((IForgeRegistryEntry)extraDrawers);
            extraTrim = new BlockTrimExtra[EnumVariant.groupCount()];
            for (int i = 0; i < extraTrim.length; ++i) {
                ModBlocks.extraTrim[i] = new BlockTrimExtra("extra_trim_" + i, "extraTrim" + i, i);
                registry.register((IForgeRegistryEntry)extraTrim[i]);
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new ItemExtraDrawers((Block)extraDrawers).setRegistryName(extraDrawers.getRegistryName()));
            for (BlockTrimExtra trim : extraTrim) {
                registry.register(new ItemTrimExtra(trim).setRegistryName(trim.getRegistryName()));
            }
        }

        @Nonnull
        public static ItemStack makeBasicDrawerItemStack(EnumBasicDrawer info, String material, int count) {
            ItemStack stack = new ItemStack((Block)extraDrawers, count, info.getMetadata());
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("material", material);
            stack.func_77982_d(data);
            return stack;
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry registry = event.getRegistry();
            ConfigManager config = StorageDrawers.config;
            ConfigManagerExt configExt = StorageDrawersExtra.config;
            for (EnumVariant variant : EnumVariant.values()) {
                ItemStack result;
                Block block;
                Block block2;
                EnumMod mod;
                if (variant == EnumVariant.DEFAULT || (mod = variant.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod))) continue;
                ItemStack plankStack = ItemStack.field_190927_a;
                if (variant.getPlankResource() != null && (block2 = Block.func_149684_b((String)variant.getPlankResource().toString())) != null) {
                    plankStack = new ItemStack(block2, 1, variant.getPlankMeta());
                }
                ItemStack slabStack = ItemStack.field_190927_a;
                if (variant.getSlabResource() != null && (block = Block.func_149684_b((String)variant.getSlabResource().toString())) != null) {
                    slabStack = new ItemStack(block, 1, variant.getSlabMeta());
                }
                String material = variant.getResource().toString();
                if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName()) && !plankStack.func_190926_b()) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                    registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL1.getUnlocalizedName() + "_" + variant.toString()));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName()) && !plankStack.func_190926_b()) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                    registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL2.getUnlocalizedName() + "_" + variant.toString()));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName()) && !plankStack.func_190926_b()) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                    registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL4.getUnlocalizedName() + "_" + variant.toString()));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName()) && !slabStack.func_190926_b()) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, material, config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                    registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF2.getUnlocalizedName() + "_" + variant.toString()));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName()) && !slabStack.func_190926_b()) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, material, config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                    registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF4.getUnlocalizedName() + "_" + variant.toString()));
                }
                if (!config.isBlockEnabled("trim") || plankStack.func_190926_b()) continue;
                result = new ItemStack((Block)extraTrim[variant.getGroupIndex()], config.getBlockRecipeOutput("trim"), variant.getGroupMeta());
                registry.register(new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), plankStack}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + variant.toString()));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            extraDrawers.initDynamic();
            ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
            modelRegistry.registerModel((IUnifiedRegister)new ExtraDrawerModel.Register());
            for (BlockTrimExtra block : extraTrim) {
                modelRegistry.registerModel((IUnifiedRegister)new ExtraTrimModel.Register(block));
            }
        }
    }
}

