/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.List;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.absorbers.MaterialAbsorberTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MaterialAbsorberBlock
extends GenericRFToolsBlock<MaterialAbsorberTileEntity, EmptyContainer> {
    public MaterialAbsorberBlock() {
        super(Material.field_151573_f, MaterialAbsorberTileEntity.class, EmptyContainer::new, "material_absorber", false);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        MaterialAbsorberTileEntity tileEntity;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof MaterialAbsorberTileEntity && (tileEntity = (MaterialAbsorberTileEntity)te).getBlockState() != null) {
            Block block = tileEntity.getBlockState().func_177230_c();
            int meta = block.func_176201_c(tileEntity.getBlockState());
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxBlockAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxBlockAbsorbtion;
            ItemStack stack = new ItemStack(block, 1, meta);
            probeInfo.text(TextFormatting.GREEN + "Block: " + stack.func_82833_r()).horizontal().progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%")).item(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        MaterialAbsorberTileEntity tileEntity = (MaterialAbsorberTileEntity)accessor.getTileEntity();
        if (tileEntity != null && tileEntity.getBlockState() != null) {
            Block block = tileEntity.getBlockState().func_177230_c();
            int meta = block.func_176201_c(tileEntity.getBlockState());
            int absorbing = tileEntity.getAbsorbing();
            int pct = (DimletConstructionConfiguration.maxBlockAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxBlockAbsorbtion;
            currenttip.add(TextFormatting.GREEN + "Block: " + new ItemStack(block, 1, meta).func_82833_r() + " (" + pct + "%)");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        Block block;
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("block") && (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tagCompound.func_74779_i("block")))) != null) {
            int meta = tagCompound.func_74762_e("meta");
            if (Item.func_150898_a((Block)block) == null) {
                list.add(TextFormatting.RED + "Block: ERROR");
            } else {
                list.add(TextFormatting.GREEN + "Block: " + new ItemStack(block, 1, meta).func_82833_r());
            }
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxBlockAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxBlockAbsorbtion;
            list.add(TextFormatting.GREEN + "Absorbed: " + pct + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Place this block on top of another block and it will");
            list.add(TextFormatting.WHITE + "gradually absorb all identical blocks in the area.");
            list.add(TextFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return -1;
    }
}

