/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.inventory;

import com.jaquadro.minecraft.gardenstuff.block.tile.TileBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.inventory.SlotBloomeryOutput;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerBloomeryFurnace
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private final IInventory tile;
    private int cookTime;
    private int totalCookTime;
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private Slot primarySlot;
    private Slot secondarySlot;
    private Slot fuelSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerBloomeryFurnace(InventoryPlayer playerInventory, IInventory containerInventory) {
        int i;
        this.tile = containerInventory;
        this.primarySlot = this.func_75146_a(new Slot(this.tile, 0, 56, 17));
        this.secondarySlot = this.func_75146_a(new Slot(this.tile, 1, 35, 17));
        this.fuelSlot = this.func_75146_a(new Slot(this.tile, 2, 56, 53));
        this.outputSlot = this.func_75146_a(new SlotBloomeryOutput(playerInventory.field_70458_d, this.tile, 3, 116, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 142)));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_175173_a((Container)this, this.tile);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.cookTime != this.tile.func_174887_a_(2)) {
                listener.func_71112_a((Container)this, 2, this.tile.func_174887_a_(2));
            }
            if (this.furnaceBurnTime != this.tile.func_174887_a_(0)) {
                listener.func_71112_a((Container)this, 0, this.tile.func_174887_a_(0));
            }
            if (this.currentItemBurnTime != this.tile.func_174887_a_(1)) {
                listener.func_71112_a((Container)this, 1, this.tile.func_174887_a_(1));
            }
            if (this.totalCookTime == this.tile.func_174887_a_(3)) continue;
            listener.func_71112_a((Container)this, 3, this.tile.func_174887_a_(3));
        }
        this.cookTime = this.tile.func_174887_a_(2);
        this.furnaceBurnTime = this.tile.func_174887_a_(0);
        this.currentItemBurnTime = this.tile.func_174887_a_(1);
        this.totalCookTime = this.tile.func_174887_a_(3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.tile.func_174885_b(id, data);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (slotIndex == this.outputSlot.field_75222_d) {
                if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd) {
                boolean merged = false;
                if (TileBloomeryFurnace.isItemFuel(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.fuelSlot.field_75222_d, this.fuelSlot.field_75222_d + 1, false);
                } else if (TileBloomeryFurnace.isItemPrimaryInput(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.primarySlot.field_75222_d, this.primarySlot.field_75222_d + 1, false);
                } else if (TileBloomeryFurnace.isItemSecondaryInput(slotStack)) {
                    merged = this.func_75135_a(slotStack, this.secondarySlot.field_75222_d, this.secondarySlot.field_75222_d + 1, false);
                }
                if (!merged && (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.func_75135_a(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.func_75135_a(slotStack, inventoryStart, hotbarStart, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, inventoryStart, hotbarEnd, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return itemStack;
    }
}

