/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.gardenstuff.core.ModCreativeTabs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.IFuelHandler;

public class BlockMetalMaterial
extends Block
implements IFuelHandler {
    public static final PropertyEnum<MetalType> VARIANT = PropertyEnum.func_177709_a((String)"variant", MetalType.class);

    public BlockMetalMaterial(String registryName, String unlocalizedName) {
        super(Material.field_151573_f);
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabGardenStuff);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)MetalType.WROUGHT_IRON_BLOCK)));
    }

    public MapColor getMapColor(IBlockState state) {
        return ((MetalType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (MetalType type : MetalType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, ((MetalType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MetalType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((MetalType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((MetalType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getBurnTime(@Nonnull ItemStack fuel) {
        if (!fuel.func_190926_b() && Block.func_149634_a((Item)fuel.func_77973_b()) == this && MetalType.byMetadata(fuel.func_77952_i()) == MetalType.WROUGHT_IRON_BLOCK) {
            return 16000;
        }
        return 0;
    }

    public static enum MetalType implements IItemEnum
    {
        WROUGHT_IRON_BLOCK(0, "wrought_iron", "wroughtIron", MapColor.field_151646_E);

        private static final MetalType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor color;

        private MetalType(int meta, String name, String unlocalizedName, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public MapColor getColor() {
            return this.color;
        }

        public static MetalType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new MetalType[MetalType.values().length];
            MetalType[] metalTypeArray = MetalType.values();
            int n = metalTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MetalType upgrade;
                MetalType.META_LOOKUP[upgrade.getMetadata()] = upgrade = metalTypeArray[i];
            }
        }
    }
}

