/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import com.jaquadro.minecraft.chameleon.resources.IItemEnum;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileCandelabra;
import com.jaquadro.minecraft.gardenstuff.core.ModCreativeTabs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCandelabra
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumMount> MOUNT = PropertyEnum.func_177709_a((String)"mount", EnumMount.class);
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    protected static final AxisAlignedBB[] WALL_BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0625, 0.0, 0.625, 0.875, 0.40625), new AxisAlignedBB(0.59375, 0.0625, 0.375, 1.0, 0.875, 0.625), new AxisAlignedBB(0.375, 0.0625, 0.59375, 0.625, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0625, 0.375, 0.40625, 0.875, 0.625), new AxisAlignedBB(0.109375, 0.0625, 0.0, 0.890625, 0.875, 0.40625), new AxisAlignedBB(0.59375, 0.0625, 0.109375, 1.0, 0.875, 0.890625), new AxisAlignedBB(0.109375, 0.0625, 0.59375, 0.890625, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0625, 0.109375, 0.40625, 0.875, 0.890625), new AxisAlignedBB(0.109375, 0.0625, 0.0, 0.890625, 0.875, 0.40625), new AxisAlignedBB(0.59375, 0.0625, 0.109375, 1.0, 0.875, 0.890625), new AxisAlignedBB(0.109375, 0.0625, 0.59375, 0.890625, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0625, 0.109375, 0.40625, 0.875, 0.890625)};
    protected static final AxisAlignedBB LEVEL0_BOUNDING_BOX = new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 0.5, 0.59375);
    protected static final AxisAlignedBB LEVEL1_BOUNDING_BOX = new AxisAlignedBB(0.359375, 0.0, 0.359375, 0.640625, 0.9375, 0.640625);
    protected static final AxisAlignedBB LEVEL3_BOUNDING_BOX = new AxisAlignedBB(0.03125, 0.0, 0.03125, 0.96875, 0.9375, 0.96875);
    protected static final AxisAlignedBB[] LEVEL2_BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.03125, 0.0, 0.359375, 0.96875, 0.9375, 0.640625), new AxisAlignedBB(0.359375, 0.0, 0.03125, 0.640625, 0.9375, 0.96875), new AxisAlignedBB(0.03125, 0.0, 0.359375, 0.96875, 0.9375, 0.640625), new AxisAlignedBB(0.359375, 0.0, 0.03125, 0.640625, 0.9375, 0.96875)};

    public BlockCandelabra(String registryName, String unlocalizedName) {
        super(Material.field_151573_f);
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(ModCreativeTabs.tabGardenStuff);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(MOUNT, (Comparable)((Object)EnumMount.FLOOR)).func_177226_a(VARIANT, (Comparable)((Object)Variant.LEVEL1)));
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Variant type : Variant.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((state = this.func_176221_a(state, source, pos)).func_177229_b(VARIANT) != Variant.LEVEL0 && state.func_177229_b(MOUNT) == EnumMount.WALL) {
            return WALL_BOUNDING_BOXES[BlockCandelabra.getWallBoundingBoxIndex(state)];
        }
        switch ((Variant)((Object)state.func_177229_b(VARIANT))) {
            case LEVEL0: {
                return LEVEL0_BOUNDING_BOX;
            }
            case LEVEL1: {
                return LEVEL1_BOUNDING_BOX;
            }
            case LEVEL2: {
                return LEVEL2_BOUNDING_BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()];
            }
            case LEVEL3: {
                return LEVEL3_BOUNDING_BOX;
            }
        }
        return LEVEL1_BOUNDING_BOX;
    }

    private static int getWallBoundingBoxIndex(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata() - 1 << 2 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = this.getTileEntityWeak(worldIn, pos);
        if (tile instanceof TileCandelabra) {
            TileCandelabra tileCandelabra = (TileCandelabra)tile;
            return state.func_177226_a((IProperty)FACING, (Comparable)tileCandelabra.getFacing()).func_177226_a(MOUNT, (Comparable)((Object)tileCandelabra.getMount()));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MOUNT, VARIANT});
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCandelabra().initialize(EnumFacing.NORTH, EnumMount.FLOOR);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public int func_149750_m(IBlockState state) {
        switch ((Variant)((Object)state.func_177229_b(VARIANT))) {
            case LEVEL0: 
            case LEVEL1: {
                return 13;
            }
            case LEVEL2: {
                return 14;
            }
            case LEVEL3: {
                return 15;
            }
        }
        return 0;
    }

    private boolean canPlaceOn(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return true;
        }
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockPos = pos.func_177972_a(facing.func_176734_d());
        if (facing.func_176740_k().func_176722_c()) {
            return world.isSideSolid(blockPos, facing, true);
        }
        if (facing == EnumFacing.UP) {
            return this.canPlaceOn(world, blockPos);
        }
        return facing == EnumFacing.DOWN;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176203_a(meta);
        if (this.canPlaceAt(world, pos, facing)) {
            if (facing.func_176740_k().func_176722_c()) {
                state = state.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.WALL)).func_177226_a((IProperty)FACING, (Comparable)facing);
            } else {
                state = state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
                if (facing == EnumFacing.UP) {
                    state = state.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.FLOOR));
                } else if (facing == EnumFacing.DOWN) {
                    state = state.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.CEILING));
                }
            }
        }
        if (Variant.byMetadata(meta) == Variant.LEVEL0) {
            state = state.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.FLOOR));
        }
        return state;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state, 2);
        TileCandelabra tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            tile.setFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
            tile.setMount((EnumMount)((Object)state.func_177229_b(MOUNT)));
        }
    }

    protected TileCandelabra getTileEntity(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileCandelabra ? (TileCandelabra)tile : null;
    }

    protected TileEntity getTileEntityWeak(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return blockAccess.func_175625_s(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileCandelabra tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile == null) {
            return;
        }
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        Variant level = (Variant)((Object)state.func_177229_b(VARIANT));
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumMount mount = (EnumMount)((Object)state.func_177229_b(MOUNT));
        float flameDepth = 0.96875f;
        if (mount == EnumMount.WALL) {
            switch (level) {
                case LEVEL1: {
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.75);
                    break;
                }
                case LEVEL2: {
                    this.renderParticleAt(world, pos, dir, 0.25, flameDepth, 0.75);
                    this.renderParticleAt(world, pos, dir, 0.75, flameDepth, 0.75);
                    break;
                }
                case LEVEL3: {
                    this.renderParticleAt(world, pos, dir, 0.25, flameDepth, 0.75);
                    this.renderParticleAt(world, pos, dir, 0.75, flameDepth, 0.75);
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.71875);
                }
            }
        } else if (mount == EnumMount.CEILING) {
            switch (level) {
                case LEVEL1: {
                    this.renderParticleAt(world, pos, dir, 0.5, (double)flameDepth - 0.3125, 0.5);
                    break;
                }
                case LEVEL2: {
                    this.renderParticleAt(world, pos, dir, 0.15625, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.84375, flameDepth, 0.5);
                    break;
                }
                case LEVEL3: {
                    this.renderParticleAt(world, pos, dir, 0.15625, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.84375, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.15625);
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.84375);
                }
            }
        } else {
            switch (level) {
                case LEVEL0: {
                    this.renderParticleAt(world, pos, dir, 0.5, 0.5, 0.5);
                    break;
                }
                case LEVEL1: {
                    this.renderParticleAt(world, pos, dir, 0.5, (double)flameDepth + 0.0625, 0.5);
                    break;
                }
                case LEVEL2: {
                    this.renderParticleAt(world, pos, dir, 0.5, (double)flameDepth + 0.0625, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.15625, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.84375, flameDepth, 0.5);
                    break;
                }
                case LEVEL3: {
                    this.renderParticleAt(world, pos, dir, 0.5, (double)flameDepth + 0.0625, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.15625, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.84375, flameDepth, 0.5);
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.15625);
                    this.renderParticleAt(world, pos, dir, 0.5, flameDepth, 0.84375);
                }
            }
        }
    }

    private void renderParticleAt(World world, BlockPos pos, EnumFacing dir, double x, double y, double z) {
        double[] out = new double[3];
        double[] in = new double[]{x, y, z};
        ChamRender.instance.state.transformCoord(in, out, ChamRenderState.ROTATION_BY_FACE_FACE[2][dir.func_176745_a()]);
        world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + out[0], (double)pos.func_177956_o() + out[1], (double)pos.func_177952_p() + out[2], 0.0, 0.0, 0.0, new int[0]);
    }

    public static enum EnumMount implements IStringSerializable
    {
        FLOOR(0, "floor"),
        WALL(1, "wall"),
        CEILING(2, "ceiling"),
        PIKE(3, "pike");

        private static final EnumMount[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumMount(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumMount byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumMount[EnumMount.values().length];
            EnumMount[] enumMountArray = EnumMount.values();
            int n = enumMountArray.length;
            for (int i = 0; i < n; ++i) {
                EnumMount upgrade;
                EnumMount.META_LOOKUP[upgrade.getMetadata()] = upgrade = enumMountArray[i];
            }
        }
    }

    public static enum Variant implements IItemEnum
    {
        LEVEL0(0, "level0"),
        LEVEL1(1, "level1"),
        LEVEL2(2, "level2"),
        LEVEL3(3, "level3");

        private static final Variant[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private Variant(int meta, String name) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static Variant byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new Variant[Variant.values().length];
            Variant[] variantArray = Variant.values();
            int n = variantArray.length;
            for (int i = 0; i < n; ++i) {
                Variant upgrade;
                Variant.META_LOOKUP[upgrade.getMetadata()] = upgrade = variantArray[i];
            }
        }
    }
}

