/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import crazypants.enderio.base.power.forge.tile.InternalRecieverTileWrapper;
import crazypants.enderio.base.power.wireless.IWirelessCharger;
import crazypants.enderio.base.power.wireless.WirelessChargerController;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.wireless.BlockNormalWirelessCharger;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileWirelessCharger
extends TileEntityEio
implements ILegacyPoweredTile.Receiver,
IWirelessCharger,
IPaintable.IPaintableTileEntity,
IRanged {
    @Store
    private int storedEnergyRF;
    private boolean registered = false;
    @Nonnull
    private BoundingBox bb = BoundingBox.UNIT_CUBE;
    private IBlockState blockState = null;
    private boolean showingRange = false;
    private static final Vector4f color = new Vector4f(0.41568628f, 0.23921569f, 0.49019608f, 0.4f);

    public TileWirelessCharger() {
        this.addICap(CapabilityEnergy.ENERGY, facing -> InternalRecieverTileWrapper.get(this, facing));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        WirelessChargerController.instance.deregisterCharger(this);
        this.registered = false;
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
            return;
        }
        if (!this.registered) {
            WirelessChargerController.instance.registerCharger(this);
            this.registered = true;
            this.disableTicking();
        }
    }

    @Override
    public boolean chargeItems(NonNullList<ItemStack> items) {
        boolean chargedItem = false;
        int available = Math.min(CapacitorKey.WIRELESS_POWER_OUTPUT.getDefault(), this.storedEnergyRF);
        int end = items.size();
        for (int i = 0; i < end && available > 0; ++i) {
            int used;
            IEnergyStorage chargable;
            ItemStack item = (ItemStack)items.get(i);
            if (item.func_190926_b() || (chargable = PowerHandlerUtil.getCapability((ICapabilityProvider)item, null)) == null || item.func_190916_E() != 1) continue;
            int max = chargable.getMaxEnergyStored();
            int cur = chargable.getEnergyStored();
            int canUse = Math.min(available, max - cur);
            if (cur >= max || (used = chargable.receiveEnergy(canUse, false)) <= 0) continue;
            this.storedEnergyRF -= used;
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return CapacitorKey.WIRELESS_POWER_INTAKE.getDefault();
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return CapacitorKey.WIRELESS_POWER_BUFFER.getDefault();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = stored;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int takeEnergy(int max) {
        int prev = this.storedEnergyRF;
        this.storedEnergyRF = Math.max(0, this.storedEnergyRF - max);
        return prev - this.storedEnergyRF;
    }

    @Override
    public boolean canConnectEnergy(@Nonnull EnumFacing from) {
        return from == EnumFacing.DOWN || !((BlockNormalWirelessCharger)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).isAntenna();
    }

    @Override
    @Nonnull
    public World getworld() {
        return this.func_145831_w();
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.field_174879_c;
    }

    @Override
    @Nonnull
    public BoundingBox getRange() {
        if (this.func_145837_r()) {
            Log.error("TileEntity " + this + " at " + this.field_174879_c + " is invalid but was not invalidated. This should not be possible!");
            return this.bb;
        }
        IBlockState actualState = this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        if (actualState != this.blockState) {
            if (!(actualState.func_177230_c() instanceof BlockNormalWirelessCharger)) {
                Log.error("TileEntity " + this + " at " + this.field_174879_c + " is assigned to a wrong block (" + actualState + "). This should not be possible unless the world was severly corrupted!");
                this.field_145850_b.func_175713_t(this.field_174879_c);
                this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1.0f, false);
                return this.bb;
            }
            this.blockState = actualState;
            this.bb = ((BlockNormalWirelessCharger)actualState.func_177230_c()).getChargingStrength(actualState, this.field_174879_c);
        }
        return this.bb;
    }

    protected void toggleRange() {
        boolean bl = this.showingRange = !this.showingRange;
        if (this.field_145850_b.field_72995_K && this.showingRange) {
            this.spawnRangeParticle();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnRangeParticle() {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileWirelessCharger>(this, color));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Override
    @Nonnull
    public BoundingBox getBounds() {
        return this.getRange();
    }
}

