/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.conduits.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class NetworkTank {
    @Nonnull
    final EnderLiquidConduit con;
    @Nonnull
    final EnumFacing conDir;
    final IFluidWrapper externalTank;
    @Nonnull
    final EnumFacing tankDir;
    @Nonnull
    final BlockPos conduitLoc;
    final boolean acceptsOuput;
    final DyeColor inputColor;
    final DyeColor outputColor;
    final int priority;
    final boolean roundRobin;
    final boolean selfFeed;
    final boolean supportsMultipleTanks;

    public NetworkTank(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
        this.con = con;
        this.conDir = conDir;
        this.conduitLoc = con.getBundle().getLocation();
        this.tankDir = conDir.func_176734_d();
        this.externalTank = AbstractLiquidConduit.getExternalFluidHandler((IBlockAccess)con.getBundle().getBundleworld(), this.conduitLoc.func_177972_a(conDir), this.tankDir);
        this.acceptsOuput = con.getConnectionMode(conDir).acceptsOutput();
        this.inputColor = con.getOutputColor(conDir);
        this.outputColor = con.getInputColor(conDir);
        this.priority = con.getOutputPriority(conDir);
        this.roundRobin = con.isRoundRobinEnabled(conDir);
        this.selfFeed = con.isSelfFeedEnabled(conDir);
        this.supportsMultipleTanks = this.externalTank != null && this.externalTank.getTankInfoWrappers().size() > 1;
    }

    public boolean isValid() {
        return this.externalTank != null && this.con.getConnectionMode(this.conDir) != ConnectionMode.DISABLED;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.conDir.hashCode();
        result = 31 * result + this.conduitLoc.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkTank other = (NetworkTank)obj;
        if (this.conDir != other.conDir) {
            return false;
        }
        return this.conduitLoc.equals((Object)other.conduitLoc);
    }
}

