/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.alloysmelter;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.recipe.BasicManyToOneRecipe;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.base.recipe.ManyToOneRecipeManager;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeInput;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.alloysmelter.VanillaSmeltingRecipe;
import crazypants.enderio.util.Prep;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class AlloyRecipeManager
extends ManyToOneRecipeManager {
    @Nonnull
    static final AlloyRecipeManager instance = new AlloyRecipeManager();
    @Nonnull
    VanillaSmeltingRecipe vanillaRecipe = new VanillaSmeltingRecipe();

    public static AlloyRecipeManager getInstance() {
        return instance;
    }

    public AlloyRecipeManager() {
        super("Alloy Smelter");
    }

    @Nonnull
    public VanillaSmeltingRecipe getVanillaRecipe() {
        return this.vanillaRecipe;
    }

    public void create() {
        MachineRecipeRegistry.instance.registerRecipe("alloysmelter", new ManyToOneMachineRecipe("AlloySmelterRecipe", "alloysmelter", this));
        MachineRecipeRegistry.instance.registerRecipe("alloysmelter", this.vanillaRecipe);
    }

    public void addRecipe(boolean prohibitDupes, @Nonnull NNList<IRecipeInput> input, @Nonnull ItemStack output, int energyCost, float xpChance) {
        RecipeOutput recipeOutput = new RecipeOutput(output, 1.0f, xpChance);
        if (prohibitDupes && input.size() > 1) {
            Log.debug("Beginning de-duping loop for recipe that outputs ", output);
            Recipe recipe = new Recipe(recipeOutput, energyCost, RecipeBonusType.NONE, (IRecipeInput[])input.toArray((Object[])new IRecipeInput[input.size()])){

                @Override
                public boolean isValidInput(int slot, @Nonnull ItemStack item) {
                    return false;
                }
            };
            NNList<List<ItemStack>> inputStacks = recipe.getInputStackAlternatives();
            List list0 = inputStacks.size() >= 1 ? (List)inputStacks.get(0) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
            List list1 = inputStacks.size() >= 2 ? (List)inputStacks.get(1) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
            List list2 = inputStacks.size() >= 3 ? (List)inputStacks.get(2) : new NNList((Object[])new ItemStack[]{Prep.getEmpty()});
            Log.debug("Got these inputs:");
            Log.debug(" slot 0: ", list0);
            Log.debug(" slot 1: ", list1);
            Log.debug(" slot 2: ", list2);
            NNList list = new NNList();
            Iterator iterator = list0.iterator();
            while (iterator.hasNext()) {
                ItemStack stack0;
                RecipeInput rinp0 = new RecipeInput(stack0, (stack0 = (ItemStack)iterator.next()).func_77952_i() != Short.MAX_VALUE, ((IRecipeInput)input.get(0)).getMulitplier(), ((IRecipeInput)input.get(0)).getSlotNumber());
                Iterator iterator2 = list1.iterator();
                while (iterator2.hasNext()) {
                    ItemStack stack1;
                    RecipeInput rinp1 = new RecipeInput(stack1, (stack1 = (ItemStack)iterator2.next()).func_77952_i() != Short.MAX_VALUE, ((IRecipeInput)input.get(1)).getMulitplier(), ((IRecipeInput)input.get(1)).getSlotNumber());
                    Iterator iterator3 = list2.iterator();
                    while (iterator3.hasNext()) {
                        ItemStack stack2 = (ItemStack)iterator3.next();
                        Tuple t = new Tuple(stack0, stack1, stack2);
                        if (t.isValid() && !list.contains((Object)t)) {
                            list.add((Object)t);
                            Log.debug("Found valid combination ", stack0, " / ", stack1, " / ", stack2);
                            this.addRecipe(new BasicManyToOneRecipe(new Recipe(recipeOutput, energyCost, RecipeBonusType.NONE, (IRecipeInput[])new NNList().addIf((Object)rinp0).addIf((Object)rinp1).addIf((Object)(input.size() >= 3 ? new RecipeInput(stack2, stack2.func_77952_i() != Short.MAX_VALUE, ((IRecipeInput)input.get(2)).getMulitplier(), ((IRecipeInput)input.get(2)).getSlotNumber()) : null)).toArray((Object[])new IRecipeInput[0]))).setSynthetic());
                            continue;
                        }
                        Log.debug("Skipping invalid combination ", stack0, " / ", stack1, " / ", stack2);
                    }
                }
            }
            if (list.isEmpty()) {
                Log.warn("Splitting alloying recipe for ", output, " into sub-recipes yielded nothing. Something may be wrong with this recipe.");
            } else {
                Log.debug("Split alloying recipe for ", output, " into ", list.size(), " sub-recipes");
                this.addRecipe(new BasicManyToOneRecipe(recipe).setDedupeInput());
            }
        } else {
            this.addRecipe(new Recipe(recipeOutput, energyCost, RecipeBonusType.NONE, (IRecipeInput[])input.toArray((Object[])new IRecipeInput[input.size()])));
        }
    }

    private static boolean eq(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i();
    }

    @Override
    public void addRecipe(@Nonnull IManyToOneRecipe recipe) {
        super.addRecipe(recipe);
        if (recipe.getInputs().length >= 2 && !recipe.isDedupeInput() && !recipe.isSynthetic()) {
            NNList inputs = new NNList();
            for (int i = 0; i < recipe.getInputs().length; ++i) {
                ItemStack input = recipe.getInputs()[i].getInput().func_77946_l();
                Things inputThing = new Things();
                inputThing.add(input);
                inputThing.setSize(input.func_190916_E());
                inputThing.setNbt(input.func_77978_p());
                inputs.add((Object)inputThing);
            }
            ItemStack output = recipe.getOutputs()[0].getOutput().func_77946_l();
            Things outputThing = new Things();
            outputThing.add(output);
            outputThing.setSize(output.func_190916_E());
            outputThing.setNbt(output.func_77978_p());
            TicProxy.registerAlloyRecipe(outputThing, (NNList<Things>)inputs);
        }
    }

    private static class Tuple {
        @Nonnull
        protected final ItemStack stack0;
        @Nonnull
        protected final ItemStack stack1;
        @Nonnull
        protected final ItemStack stack2;

        Tuple(@Nullable ItemStack stack0, @Nullable ItemStack stack1, @Nullable ItemStack stack2) {
            this.stack0 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack0, Prep.getEmpty()});
            this.stack1 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack1, Prep.getEmpty()});
            this.stack2 = (ItemStack)NullHelper.first((Object[])new ItemStack[]{stack2, Prep.getEmpty()});
        }

        boolean isValid() {
            return Prep.isValid(this.stack0) && Prep.isValid(this.stack1) && !AlloyRecipeManager.eq(this.stack0, this.stack1) && !AlloyRecipeManager.eq(this.stack0, this.stack2) && !AlloyRecipeManager.eq(this.stack2, this.stack1);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            return this == other || AlloyRecipeManager.eq(this.stack0, other.stack0) && AlloyRecipeManager.eq(this.stack1, other.stack1) && AlloyRecipeManager.eq(this.stack2, other.stack2) || AlloyRecipeManager.eq(this.stack0, other.stack1) && AlloyRecipeManager.eq(this.stack1, other.stack0) && AlloyRecipeManager.eq(this.stack2, other.stack2) || AlloyRecipeManager.eq(this.stack0, other.stack0) && AlloyRecipeManager.eq(this.stack1, other.stack2) && AlloyRecipeManager.eq(this.stack2, other.stack1) || AlloyRecipeManager.eq(this.stack0, other.stack2) && AlloyRecipeManager.eq(this.stack1, other.stack1) && AlloyRecipeManager.eq(this.stack2, other.stack0) || AlloyRecipeManager.eq(this.stack0, other.stack1) && AlloyRecipeManager.eq(this.stack1, other.stack2) && AlloyRecipeManager.eq(this.stack2, other.stack0) || AlloyRecipeManager.eq(this.stack0, other.stack0) && AlloyRecipeManager.eq(this.stack1, other.stack2) && AlloyRecipeManager.eq(this.stack2, other.stack1);
        }

        public int hashCode() {
            return this.stack0.hashCode() ^ this.stack1.hashCode() ^ this.stack2.hashCode();
        }
    }
}

