/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.thaumcraft;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.lang.Lang;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ThaumaturgeRobesUpgrade
extends AbstractUpgrade {
    @Nonnull
    public static final String UPGRADE_NAME = "thaumaturge_robes_";
    @Nonnull
    public static final ThaumaturgeRobesUpgrade CHEST = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.CHEST);
    @Nonnull
    public static final ThaumaturgeRobesUpgrade LEGS = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.LEGS);
    @Nonnull
    public static final ThaumaturgeRobesUpgrade BOOTS = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.FEET);
    @Nonnull
    private final EntityEquipmentSlot slot;

    public ThaumaturgeRobesUpgrade(@Nonnull EntityEquipmentSlot slot) {
        super(UPGRADE_NAME + slot.func_188450_d(), "enderio.darksteel.upgrade.thaumaturge_robes." + slot.func_188450_d(), DarkSteelConfig.thaumaturgeRobesCost);
        this.slot = slot;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(this.slot) && item.hasUpgradeCallbacks(this) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public List<Supplier<String>> getItemClassesForTooltip() {
        switch (this.slot) {
            case FEET: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_FEET::get;
                return new NNList(objectArray);
            }
            case LEGS: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_LEGS::get;
                return new NNList(objectArray);
            }
            case CHEST: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_CHEST::get;
                return new NNList(objectArray);
            }
            case HEAD: {
                Object[] objectArray = new Supplier[1];
                objectArray[0] = Lang.DSU_CLASS_ARMOR_HEAD::get;
                return new NNList(objectArray);
            }
        }
        Object[] objectArray = new Supplier[1];
        objectArray[0] = Lang.DSU_CLASS_ARMOR::get;
        return new NNList(objectArray);
    }
}

