/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.upgrades;

import com.google.common.collect.Multimap;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public interface IDarkSteelUpgrade
extends IForgeRegistryEntry<IDarkSteelUpgrade> {
    @Nonnull
    public String getUnlocalizedName();

    public int getLevelCost();

    @Nonnull
    @Deprecated
    public ItemStack getUpgradeItem();

    @Deprecated
    @Nonnull
    default public String getUpgradeItemName() {
        return this.getUpgradeItem().func_82833_r();
    }

    @Deprecated
    default public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        ItemStack upgradeItem = this.getUpgradeItem();
        return !stack.func_190926_b() && upgradeItem.func_77973_b() == stack.func_77973_b() && (upgradeItem.func_77952_i() == Short.MAX_VALUE || upgradeItem.func_77952_i() == stack.func_77952_i()) && stack.func_190916_E() == upgradeItem.func_190916_E();
    }

    default public boolean hasUpgrade(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IDarkSteelItem ? this.hasUpgrade(stack, (IDarkSteelItem)stack.func_77973_b()) : false;
    }

    public boolean hasUpgrade(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    default public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return !this.hasUpgrade(stack, item);
    }

    default public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return true;
    }

    public void addToItem(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    @Nonnull
    public Pair<ItemStack, Integer> removeFromItem(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

    default public void onPlayerTick(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void doMultiplayerSFX(@Nonnull EntityPlayer otherPlayer) {
    }

    default public void addAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack, @Nonnull Multimap<String, AttributeModifier> map) {
    }

    @Nonnull
    default public List<IDarkSteelUpgrade> getDependencies() {
        return Collections.emptyList();
    }

    @Nonnull
    default public List<Supplier<String>> getItemClassesForTooltip() {
        return Collections.emptyList();
    }

    @Nonnull
    default public List<IRule> getRules() {
        return Collections.emptyList();
    }

    public static interface IRule {
        @Nonnull
        public CheckResult check(@Nonnull ItemStack var1, @Nonnull IDarkSteelItem var2);

        public static interface WithTooltip
        extends IRule {
            @Nonnull
            public ITextComponent getTooltip();
        }

        public static interface ItemType
        extends IRule {
            @Nonnull
            public ITextComponent getTooltip();
        }

        public static interface Prerequisite
        extends IRule {
            @Override
            @Nonnull
            default public CheckResult check(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
                return this.getPrerequisite().hasUpgrade(stack, item) ? CheckResult.PASS : new CheckResult((ITextComponent)new TextComponentTranslation("enderio.darksteel.upgrades.check.prerequisite.missing", new Object[]{new TextComponentTranslation(this.getPrerequisite().getUnlocalizedName() + ".name", new Object[0])}));
            }

            @Nonnull
            public IDarkSteelUpgrade getPrerequisite();
        }

        public static interface StaticRule
        extends IRule {
        }

        public static final class CheckResult {
            @Nonnull
            public static final CheckResult PASS = new CheckResult(true);
            @Nonnull
            public static final CheckResult SILENT_FAIL = new CheckResult(false);
            private final boolean passed;
            @Nullable
            private final ITextComponent result;

            public CheckResult(ITextComponent result) {
                this.passed = false;
                this.result = result;
            }

            private CheckResult(boolean passed) {
                this.passed = passed;
                this.result = null;
            }

            public boolean passes() {
                return this.passed;
            }

            public boolean hasResult() {
                return this.result != null;
            }

            @Nonnull
            public ITextComponent getResult() {
                if (this.result != null) {
                    return this.result;
                }
                throw new NullPointerException();
            }
        }
    }
}

