/*
 * Decompiled with CFR 0.152.
 */
package com.raden93.veganlife.block.jute;

import com.raden93.veganlife.config.VeganConfig;
import com.raden93.veganlife.init.VeganLifeItems;
import com.raden93.veganlife.init.VeganLifeTabs;
import com.raden93.veganlife.util.BlockUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BaleOfJuteBlock
extends BlockRotatedPillar {
    public static final int MAX_RETTING_STAGE = 3;
    public static final int MIN_RETTING_VALUE = 0;
    public static final PropertyInteger RETTING = PropertyInteger.func_177719_a((String)"retting", (int)0, (int)3);

    public BaleOfJuteBlock() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RETTING, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(VeganLifeTabs.veganLifeTab);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176298_M, RETTING});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState axisState = super.func_176203_a(meta);
        EnumFacing.Axis axis = (EnumFacing.Axis)axisState.func_177229_b((IProperty)field_176298_M);
        int stage = meta & 3;
        return this.func_176223_P().func_177226_a((IProperty)RETTING, (Comparable)Integer.valueOf(stage)).func_177226_a((IProperty)field_176298_M, (Comparable)axis);
    }

    public int func_176201_c(IBlockState state) {
        int stage = (Integer)state.func_177229_b((IProperty)RETTING);
        return (super.func_176201_c(state) & 0xC) + stage;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        int rettingValue = BaleOfJuteBlock.getRettedValue(world, pos);
        if (rettingValue < 3 && BlockUtil.isBlockInOrAdjacentMaterial(world, pos, Material.field_151586_h)) {
            if (!this.isHardMode() || (double)random.nextFloat() < 0.5) {
                int newValue = rettingValue + 1;
                if (newValue >= BaleOfJuteBlock.getMaxRettingValue()) {
                    newValue = 3;
                }
                IBlockState newState = world.func_180495_p(pos).func_177226_a((IProperty)RETTING, (Comparable)Integer.valueOf(newValue));
                world.func_175656_a(pos, newState);
            }
        }
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if ((Integer)state.func_177229_b((IProperty)RETTING) >= BaleOfJuteBlock.getMaxRettingValue()) {
            if (VeganConfig.JUTE_CONSTANTS.JUTE_FIBER_RANDOM_DROPS == 0) {
                return VeganConfig.JUTE_CONSTANTS.JUTE_FIBER_BASE_DROPS;
            }
            return random.nextInt(VeganConfig.JUTE_CONSTANTS.JUTE_FIBER_RANDOM_DROPS) + VeganConfig.JUTE_CONSTANTS.JUTE_FIBER_BASE_DROPS;
        }
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)RETTING) >= BaleOfJuteBlock.getMaxRettingValue()) {
            return VeganLifeItems.jute_fibre_item;
        }
        return super.func_180660_a(state, random, fortune);
    }

    public static float getRettingStatus(World world, BlockPos pos) {
        return (float)BaleOfJuteBlock.getRettedValue(world, pos) / (float)BaleOfJuteBlock.getMaxRettingValue();
    }

    private static int getRettedValue(World world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)RETTING);
    }

    private static int getMaxRettingValue() {
        return VeganConfig.JUTE_CONSTANTS.JUTE_BALE_RETTING_STAGES;
    }

    private static boolean isHardMode() {
        return VeganConfig.JUTE_CONSTANTS.JUTE_BALE_RETTING_HARDMODE;
    }
}

