/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerEnderCap<T extends IItemHandler, S extends TileEntity>
extends Container
implements GhostSlot.IGhostSlotAware {
    @Nonnull
    protected final Map<Slot, Point> slotLocations = Maps.newLinkedHashMap();
    protected int startPlayerSlot;
    protected int endPlayerSlot;
    protected int startHotBarSlot;
    protected int endHotBarSlot;
    @Nonnull
    private final T inv;
    @Nonnull
    private final InventoryPlayer playerInv;
    @Nullable
    private final S te;
    private boolean initRan = false;

    public Map<Slot, Point> getSlotLocations() {
        return this.slotLocations;
    }

    @Nonnull
    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public ContainerEnderCap(@Nonnull InventoryPlayer playerInv, @Nonnull T itemHandler, @Nullable S te) {
        this.inv = (IItemHandler)ContainerEnderCap.checkNotNull(itemHandler);
        this.playerInv = ContainerEnderCap.checkNotNull(playerInv);
        this.te = te;
        this.init();
    }

    @Nonnull
    public final <X> X init() {
        int i;
        this.addSlots();
        int x = this.getPlayerInventoryOffset().x;
        int y = this.getPlayerInventoryOffset().y;
        this.startPlayerSlot = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Slot slot = new Slot((IInventory)this.playerInv, j + i * 9 + 9, x + j * 18, y + i * 18);
                this.func_75146_a(slot);
            }
        }
        this.endPlayerSlot = this.field_75151_b.size();
        this.startHotBarSlot = this.field_75151_b.size();
        for (i = 0; i < 9; ++i) {
            Slot slot = new Slot((IInventory)this.playerInv, i, x + i * 18, y + 58);
            this.func_75146_a(slot);
        }
        this.endHotBarSlot = this.field_75151_b.size();
        this.initRan = true;
        return (X)this;
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slotIn) {
        this.slotLocations.put(slotIn, new Point(slotIn.field_75223_e, slotIn.field_75221_f));
        return super.func_75146_a(slotIn);
    }

    @Nonnull
    public List<Slot> getPlayerSlots() {
        return this.field_75151_b.stream().filter(x -> x.field_75224_c == this.playerInv).collect(Collectors.toList());
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(0, 54);
    }

    @Nonnull
    public T getItemHandler() {
        return this.inv;
    }

    @Nullable
    public S getTileEntity() {
        return this.te;
    }

    @Nonnull
    public S getTileEntityNN() {
        return (S)((TileEntity)NullHelper.notnull(this.te, "Internal logic error, TE-less GUI accessing TE"));
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        if (!this.initRan) {
            throw new RuntimeException("Ender IO Internal Error 10T (report this to the Ender IO devs)");
        }
        S te2 = this.te;
        if (te2 != null) {
            World world = te2.func_145831_w();
            BlockPos pos = te2.func_174877_v();
            if (player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 64.0) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (te2 != tileEntity) {
                return false;
            }
        }
        return true;
    }

    protected abstract void addSlots();

    @Override
    public void setGhostSlotContents(int slot, @Nonnull ItemStack stack, int realsize) {
        if (this.te instanceof TileEntityBase) {
            ((TileEntityBase)((Object)this.te)).setGhostSlotContents(slot, stack, realsize);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer p_82846_1_, int p_82846_2_) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(p_82846_2_);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int minPlayerSlot = this.field_75151_b.size() - this.playerInv.field_70462_a.size();
            if (p_82846_2_ < minPlayerSlot ? !this.func_75135_a(itemstack1, minPlayerSlot, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, minPlayerSlot, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    protected boolean func_75135_a(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        ItemStack itemstack1;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reversOrder) {
            checkIndex = toIndex - 1;
        }
        if (par1ItemStack.func_77985_e()) {
            while (!par1ItemStack.func_190926_b() && (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (!itemstack1.func_190926_b() && itemstack1.func_77973_b() == par1ItemStack.func_77973_b() && (!par1ItemStack.func_77981_g() || par1ItemStack.func_77952_i() == itemstack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.func_75214_a(par1ItemStack) && par1ItemStack != itemstack1) {
                    int maxStackSize;
                    int mergedSize = itemstack1.func_190916_E() + par1ItemStack.func_190916_E();
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.func_77976_d(), slot.func_178170_b(par1ItemStack)))) {
                        par1ItemStack.func_190920_e(0);
                        itemstack1.func_190920_e(mergedSize);
                        slot.func_75218_e();
                        result = true;
                    } else if (itemstack1.func_190916_E() < maxStackSize) {
                        par1ItemStack.func_190918_g(maxStackSize - itemstack1.func_190916_E());
                        itemstack1.func_190920_e(maxStackSize);
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (!par1ItemStack.func_190926_b()) {
            checkIndex = reversOrder ? toIndex - 1 : fromIndex;
            while (!reversOrder && checkIndex < toIndex || reversOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.field_75151_b.get(checkIndex);
                itemstack1 = slot.func_75211_c();
                if (itemstack1.func_190926_b() && slot.func_75214_a(par1ItemStack)) {
                    ItemStack in = par1ItemStack.func_77946_l();
                    in.func_190920_e(Math.min(in.func_190916_E(), slot.func_178170_b(par1ItemStack)));
                    slot.func_75215_d(in);
                    slot.func_75218_e();
                    par1ItemStack.func_190918_g(in.func_190916_E());
                    result = true;
                    break;
                }
                if (reversOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public void func_75142_b() {
        SPacketUpdateTileEntity updatePacket;
        super.func_75142_b();
        SPacketUpdateTileEntity sPacketUpdateTileEntity = updatePacket = this.te != null ? this.te.func_189518_D_() : null;
        if (updatePacket != null) {
            for (IContainerListener containerListener : this.field_75149_d) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)containerListener).field_71135_a.func_147359_a((Packet)updatePacket);
            }
        }
    }
}

