/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.ClientATHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();
    public static final GuiBase BLANK_GUI = new GuiBase(){

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }
    };

    public static void setupDrawing() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void playSound(SoundEvent event, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)event, (float)pitch));
    }

    public static void playClickSound() {
        GuiHelper.playSound(SoundEvents.field_187909_gi, 1.0f);
    }

    public static void drawTexturedRect(int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        if (col.isEmpty()) {
            col = Color4I.WHITE;
        }
        if (u0 == u1 || v0 == v1) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            GuiHelper.addRectToBufferWithUV(buffer, x, y, w, h, col, u0, v0, u1, v1);
            tessellator.func_78381_a();
        }
    }

    public static void addRectToBuffer(BufferBuilder buffer, int x, int y, int w, int h, Color4I col) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void addRectToBufferWithUV(BufferBuilder buffer, int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(u0, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(u1, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(u1, v0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(u0, v0).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void drawHollowRect(int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(x, y, w, h);
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(buffer, x, y + h - 1, w, 1, col);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void drawRectWithShade(int x, int y, int w, int h, Color4I col, int intensity) {
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y, w - 1, 1, col);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y, 1, 1, col);
        GuiHelper.addRectToBuffer(buffer, x, y + h - 1, 1, 1, col);
        col = col.mutable().addBrightness(-intensity);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 1, 1, col);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static boolean drawItem(ItemStack stack, double x, double y, double scaleX, double scaleY, boolean renderOverlay) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean result = true;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.field_77023_b = 180.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)32.0);
        if (scaleX != 1.0 || scaleY != 1.0) {
            GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        }
        RenderHelper.func_74520_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179098_w();
        try {
            renderItem.func_180450_b(stack, 0, 0);
            if (renderOverlay) {
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                if (font == null) {
                    font = Minecraft.func_71410_x().field_71466_p;
                }
                renderItem.func_180453_a(font, stack, 0, 0, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = false;
        }
        GlStateManager.func_179121_F();
        renderItem.field_77023_b = 0.0f;
        return result;
    }

    public static boolean drawItem(ItemStack stack, double x, double y, boolean renderOverlay) {
        return GuiHelper.drawItem(stack, x, y, 1.0, 1.0, renderOverlay);
    }

    public static void pushScissor(ScaledResolution screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(ScaledResolution screen) {
        SCISSOR.pop();
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            ((Scissor)SCISSOR.lastElement()).scissor(screen);
        }
    }

    public static void setFixUnicode(boolean enabled) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        int mode = enabled ? 9729 : 9728;
        for (int i = 0; i < 256; ++i) {
            ResourceLocation loc = ClientATHelper.getFontUnicodePage(i);
            if (loc == null) continue;
            textureManager.func_110577_a(loc);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
        }
    }

    public static String clickEventToString(@Nullable ClickEvent event) {
        if (event == null) {
            return "";
        }
        switch (event.func_150669_a()) {
            case OPEN_URL: 
            case CHANGE_PAGE: {
                return event.func_150668_b();
            }
            case OPEN_FILE: {
                return "file:" + event.func_150668_b();
            }
            case RUN_COMMAND: {
                return "command:" + event.func_150668_b();
            }
            case SUGGEST_COMMAND: {
                return "suggest_command:" + event.func_150668_b();
            }
        }
        return "";
    }

    public static void addStackTooltip(ItemStack stack, List<String> list) {
        GuiHelper.addStackTooltip(stack, list, "");
    }

    public static void addStackTooltip(ItemStack stack, List<String> list, String prefix) {
        List tooltip = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        list.add((prefix.isEmpty() ? stack.func_77953_t().field_77937_e.toString() : prefix) + (String)tooltip.get(0));
        for (int i = 1; i < tooltip.size(); ++i) {
            list.add(TextFormatting.GRAY + (String)tooltip.get(i));
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(ScaledResolution screen) {
            int scale = screen.func_78325_e();
            int sx = this.x * scale;
            int sy = (int)((screen.func_78324_d() - (double)(this.y + this.h)) * (double)scale);
            int sw = this.w * scale;
            int sh = this.h * scale;
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

